package gov.va.vamf.scheduling.direct.domain.eligibility;

import com.agilex.healthcare.veteranappointment.domain.Namespace;
import gov.va.vamf.scheduling.direct.domain.CustomMessages;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "elibility-facility", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class EligibilityFacility {
    @XmlElement
    private String name;
    @XmlElement
    private String siteCode;
    @XmlElement
    private CustomMessages customMessages;

    public EligibilityFacility() {
    }

    public EligibilityFacility(String name, String siteCode) {
        this.name = name;
        this.siteCode = siteCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public CustomMessages getCustomMessages() { return customMessages; }

    public void setCustomMessages(CustomMessages customMessages) {
        this.customMessages = customMessages;
    }
}
